<?php
/**
 * صفحة السجلات
 * Activity Logs Page
 */

require_once __DIR__ . '/config.php';
require_once __DIR__ . '/db.php';

if (!isLoggedIn()) {
    header('Location: login.php');
    exit;
}

$deviceId = $_GET['device_id'] ?? null;
$logs = getActivityLogs($deviceId, 100);
$devices = getAllDevices();
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>السجلات - لوحة التحكم</title>
    <link href="https://fonts.googleapis.com/css2?family=Tajawal:wght@400;500;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        :root {
            --primary: #6366f1;
            --primary-dark: #4f46e5;
            --secondary: #ec4899;
            --success: #10b981;
            --warning: #f59e0b;
            --danger: #ef4444;
            --dark: #1e1b4b;
            --darker: #0f0d24;
            --light: #f8fafc;
            --gray: #64748b;
            --card-bg: rgba(30, 27, 75, 0.8);
            --glass: rgba(255, 255, 255, 0.05);
        }
        
        * { margin: 0; padding: 0; box-sizing: border-box; }
        
        body {
            font-family: 'Tajawal', sans-serif;
            background: linear-gradient(135deg, var(--darker) 0%, var(--dark) 50%, #1a1a2e 100%);
            min-height: 100vh;
            color: var(--light);
        }
        
        .navbar {
            background: var(--glass);
            backdrop-filter: blur(20px);
            padding: 1rem 2rem;
            display: flex;
            justify-content: space-between;
            align-items: center;
            border-bottom: 1px solid rgba(255,255,255,0.1);
            position: sticky;
            top: 0;
            z-index: 1000;
        }
        
        .navbar h1 {
            font-size: 1.5rem;
            background: linear-gradient(135deg, var(--primary), var(--secondary));
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
        }
        
        .navbar-links {
            display: flex;
            gap: 1rem;
        }
        
        .navbar-links a {
            color: var(--light);
            text-decoration: none;
            padding: 0.5rem 1rem;
            border-radius: 8px;
            transition: all 0.3s;
        }
        
        .navbar-links a:hover {
            background: var(--glass);
        }
        
        .container {
            max-width: 1200px;
            margin: 0 auto;
            padding: 2rem;
        }
        
        .page-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 2rem;
            flex-wrap: wrap;
            gap: 1rem;
        }
        
        .page-header h2 {
            font-size: 1.5rem;
            display: flex;
            align-items: center;
            gap: 0.5rem;
        }
        
        .filter-select {
            padding: 0.75rem 1rem;
            background: var(--glass);
            border: 1px solid rgba(255,255,255,0.1);
            border-radius: 10px;
            color: var(--light);
            font-family: inherit;
            font-size: 1rem;
            cursor: pointer;
        }
        
        .filter-select option {
            background: var(--dark);
        }
        
        .logs-table {
            width: 100%;
            background: var(--card-bg);
            border-radius: 16px;
            overflow: hidden;
            border: 1px solid rgba(255,255,255,0.1);
        }
        
        .logs-table table {
            width: 100%;
            border-collapse: collapse;
        }
        
        .logs-table th,
        .logs-table td {
            padding: 1rem;
            text-align: right;
            border-bottom: 1px solid rgba(255,255,255,0.05);
        }
        
        .logs-table th {
            background: rgba(0,0,0,0.2);
            font-weight: 600;
            color: var(--gray);
        }
        
        .logs-table tr:hover {
            background: var(--glass);
        }
        
        .logs-table tr:last-child td {
            border-bottom: none;
        }
        
        .action-badge {
            padding: 0.25rem 0.75rem;
            border-radius: 20px;
            font-size: 0.8rem;
            font-weight: 500;
        }
        
        .action-badge.stream_start { background: rgba(16, 185, 129, 0.2); color: var(--success); }
        .action-badge.stream_end { background: rgba(239, 68, 68, 0.2); color: var(--danger); }
        .action-badge.device_register { background: rgba(99, 102, 241, 0.2); color: var(--primary); }
        .action-badge.device_online { background: rgba(16, 185, 129, 0.2); color: var(--success); }
        .action-badge.device_offline { background: rgba(100, 116, 139, 0.2); color: var(--gray); }
        
        .empty-state {
            text-align: center;
            padding: 4rem 2rem;
        }
        
        .empty-state i {
            font-size: 4rem;
            color: var(--gray);
            margin-bottom: 1rem;
        }
        
        @media (max-width: 768px) {
            .container { padding: 1rem; }
            
            .logs-table {
                overflow-x: auto;
            }
            
            .logs-table table {
                min-width: 600px;
            }
        }
    </style>
</head>
<body>
    <nav class="navbar">
        <h1><i class="fas fa-list"></i> السجلات</h1>
        <div class="navbar-links">
            <a href="index.php"><i class="fas fa-home"></i> الرئيسية</a>
            <a href="logout.php"><i class="fas fa-sign-out-alt"></i> خروج</a>
        </div>
    </nav>
    
    <div class="container">
        <div class="page-header">
            <h2><i class="fas fa-history"></i> سجل النشاطات</h2>
            
            <select class="filter-select" onchange="filterByDevice(this.value)">
                <option value="">جميع الأجهزة</option>
                <?php foreach ($devices as $device): ?>
                <option value="<?php echo $device['device_id']; ?>" <?php echo $deviceId === $device['device_id'] ? 'selected' : ''; ?>>
                    <?php echo htmlspecialchars($device['device_name'] ?: $device['device_id']); ?>
                </option>
                <?php endforeach; ?>
            </select>
        </div>
        
        <div class="logs-table">
            <?php if (empty($logs)): ?>
            <div class="empty-state">
                <i class="fas fa-inbox"></i>
                <h3>لا توجد سجلات</h3>
                <p>سيتم عرض النشاطات هنا عند حدوثها</p>
            </div>
            <?php else: ?>
            <table>
                <thead>
                    <tr>
                        <th>التاريخ والوقت</th>
                        <th>الجهاز</th>
                        <th>الإجراء</th>
                        <th>التفاصيل</th>
                        <th>عنوان IP</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($logs as $log): ?>
                    <tr>
                        <td><?php echo date('Y/m/d H:i:s', strtotime($log['created_at'])); ?></td>
                        <td><?php echo htmlspecialchars(substr($log['device_id'] ?? 'N/A', 0, 12)); ?>...</td>
                        <td>
                            <span class="action-badge <?php echo $log['action']; ?>">
                                <?php 
                                $actions = [
                                    'stream_start' => 'بدء البث',
                                    'stream_end' => 'إنهاء البث',
                                    'device_register' => 'تسجيل جهاز',
                                    'device_online' => 'اتصال',
                                    'device_offline' => 'قطع اتصال'
                                ];
                                echo $actions[$log['action']] ?? $log['action'];
                                ?>
                            </span>
                        </td>
                        <td><?php echo htmlspecialchars($log['details'] ?? '-'); ?></td>
                        <td><?php echo htmlspecialchars($log['ip_address']); ?></td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
            <?php endif; ?>
        </div>
    </div>
    
    <script>
        function filterByDevice(deviceId) {
            if (deviceId) {
                window.location.href = 'logs.php?device_id=' + deviceId;
            } else {
                window.location.href = 'logs.php';
            }
        }
    </script>
</body>
</html>
