<?php
/**
 * ملف الإعدادات الرئيسي للوحة التحكم
 * Live Streaming Control Panel Configuration
 */

// منع الوصول المباشر
if (!defined('PANEL_ACCESS')) {
    define('PANEL_ACCESS', true);
}

// إعدادات قاعدة البيانات (SQLite - لا تحتاج تثبيت)
define('DB_PATH', __DIR__ . '/data/panel.db');
define('DATA_DIR', __DIR__ . '/data');

// إعدادات الأمان
define('ADMIN_USERNAME', 'admin');
define('ADMIN_PASSWORD', 'admin123'); // غير هذا في الإنتاج!
define('SESSION_TIMEOUT', 3600); // ساعة واحدة

// إعدادات البث
define('DEFAULT_VIDEO_WIDTH', 640);
define('DEFAULT_VIDEO_HEIGHT', 480);
define('DEFAULT_STREAM_DURATION', 300000); // 5 دقائق بالمللي ثانية
define('MAX_STREAM_DURATION', 1800000); // 30 دقيقة

// إعدادات الخادم
define('SIGNALING_PORT', 8080);
define('ICE_SERVERS', json_encode([
    ['urls' => 'stun:stun.l.google.com:19302'],
    ['urls' => 'stun:stun1.l.google.com:19302'],
    ['urls' => 'stun:stun2.l.google.com:19302']
]));

// المنطقة الزمنية
date_default_timezone_set('Asia/Riyadh');

// بدء الجلسة
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// دالة للتحقق من تسجيل الدخول
function isLoggedIn() {
    return isset($_SESSION['logged_in']) && $_SESSION['logged_in'] === true;
}

// دالة لإنشاء معرف فريد
function generateUniqueId($length = 16) {
    return bin2hex(random_bytes($length / 2));
}

// دالة للحصول على IP الزائر
function getClientIP() {
    $ipaddress = '';
    if (isset($_SERVER['HTTP_CLIENT_IP']))
        $ipaddress = $_SERVER['HTTP_CLIENT_IP'];
    else if(isset($_SERVER['HTTP_X_FORWARDED_FOR']))
        $ipaddress = $_SERVER['HTTP_X_FORWARDED_FOR'];
    else if(isset($_SERVER['HTTP_X_FORWARDED']))
        $ipaddress = $_SERVER['HTTP_X_FORWARDED'];
    else if(isset($_SERVER['HTTP_FORWARDED_FOR']))
        $ipaddress = $_SERVER['HTTP_FORWARDED_FOR'];
    else if(isset($_SERVER['HTTP_FORWARDED']))
        $ipaddress = $_SERVER['HTTP_FORWARDED'];
    else if(isset($_SERVER['REMOTE_ADDR']))
        $ipaddress = $_SERVER['REMOTE_ADDR'];
    else
        $ipaddress = 'UNKNOWN';
    return $ipaddress;
}
