# 📱 لوحة التحكم للبث المباشر
# Live Streaming Control Panel

## 📋 نظرة عامة

هذه لوحة تحكم PHP بسيطة للتحكم في البث المباشر من الهواتف. تدعم:
- بث الكاميرا (أمامية/خلفية)
- بث الشاشة
- بث الصوت
- إدارة أجهزة متعددة

## ⚙️ المتطلبات

- PHP 7.4 أو أعلى
- دعم SQLite (مفعّل افتراضياً في معظم خوادم PHP)
- لا حاجة لـ MySQL أو أي قاعدة بيانات خارجية

## 🚀 التثبيت

1. ارفع مجلد `panel` إلى الخادم
2. تأكد من أن المجلد قابل للكتابة (لإنشاء ملف قاعدة البيانات)
3. افتح اللوحة في المتصفح: `https://yourserver.com/panel/`
4. سجل دخولك باستخدام:
   - اسم المستخدم: `admin`
   - كلمة المرور: `admin123`

⚠️ **مهم**: غيّر كلمة المرور في ملف `config.php` قبل الاستخدام الفعلي!

## 📁 هيكل الملفات

```
panel/
├── config.php          # الإعدادات الرئيسية
├── db.php              # قاعدة البيانات SQLite
├── index.php           # الصفحة الرئيسية
├── login.php           # صفحة تسجيل الدخول
├── logout.php          # تسجيل الخروج
├── logs.php            # عرض السجلات
├── .htaccess           # إعدادات الحماية
├── api/
│   ├── app.php         # API للتطبيق
│   ├── devices.php     # API لإدارة الأجهزة
│   ├── stream.php      # API لجلسات البث
│   └── signaling.php   # API للـ WebRTC Signaling
└── data/
    └── panel.db        # قاعدة البيانات (تُنشأ تلقائياً)
```

## 🔌 API للتطبيق

### تسجيل الجهاز
```
POST /panel/api/app.php
{
    "action": "register",
    "device_id": "unique-device-id",
    "device_name": "اسم الجهاز",
    "device_model": "Samsung Galaxy S21",
    "android_version": "13"
}
```

### نبضة القلب (Heartbeat)
```
POST /panel/api/app.php
{
    "action": "heartbeat",
    "device_id": "unique-device-id"
}
```

الاستجابة إذا كان هناك طلب بث:
```json
{
    "success": true,
    "has_pending_stream": true,
    "pending_stream": {
        "session_id": "abc123...",
        "stream_type": "camera",
        "camera_facing": "front"
    }
}
```

### قبول طلب البث
```
POST /panel/api/app.php
{
    "action": "accept_stream",
    "device_id": "unique-device-id",
    "session_id": "abc123..."
}
```

### رفض طلب البث (مثلاً الشاشة مغلقة)
```
POST /panel/api/app.php
{
    "action": "reject_stream",
    "session_id": "abc123...",
    "reason": "screen_off"
}
```

### الحصول على رسائل Signaling
```
GET /panel/api/app.php?action=get_signaling&session_id=abc123...
```

### إرسال SDP Answer
```
POST /panel/api/app.php
{
    "action": "send_answer",
    "session_id": "abc123...",
    "sdp": "v=0\r\no=..."
}
```

### إرسال ICE Candidate
```
POST /panel/api/app.php
{
    "action": "send_ice",
    "session_id": "abc123...",
    "candidate": {
        "candidate": "...",
        "sdpMid": "0",
        "sdpMLineIndex": 0
    }
}
```

## 🔄 آلية العمل

1. **التطبيق** يسجل نفسه عند التثبيت
2. **التطبيق** يرسل heartbeat كل 10 ثواني
3. **لوحة التحكم** تعرض الأجهزة المتصلة
4. عند الضغط على "بث مباشر":
   - لوحة التحكم تنشئ جلسة بث
   - التطبيق يكتشفها عبر heartbeat
   - التطبيق يقبل/يرفض الطلب
   - يتم تبادل SDP و ICE عبر signaling API
   - يبدأ البث عبر WebRTC

## 🔐 الأمان

- قاعدة البيانات محمية من الوصول المباشر
- جميع الطلبات تتطلب معرف جهاز صحيح
- الجلسات تنتهي تلقائياً
- سجل كامل لجميع النشاطات

## 🛠️ التخصيص

### تغيير بيانات الدخول
عدّل في `config.php`:
```php
define('ADMIN_USERNAME', 'admin');
define('ADMIN_PASSWORD', 'your_secure_password');
```

### تغيير دقة الفيديو
عدّل في `config.php`:
```php
define('DEFAULT_VIDEO_WIDTH', 1280);
define('DEFAULT_VIDEO_HEIGHT', 720);
```

### إضافة خوادم TURN
عدّل في `config.php`:
```php
define('ICE_SERVERS', json_encode([
    ['urls' => 'stun:stun.l.google.com:19302'],
    [
        'urls' => 'turn:your-turn-server.com:3478',
        'username' => 'user',
        'credential' => 'password'
    ]
]));
```

## 📝 ملاحظات

- البث يعمل عبر WebRTC (P2P)
- يُفضل استخدام HTTPS للأمان
- في حالة NAT معقد، قد تحتاج خادم TURN
- الرسائل القديمة تُحذف تلقائياً بعد ساعة

## 📞 الدعم

للمساعدة أو الإبلاغ عن مشاكل، تواصل معنا.
